<?php
include 'db.php';
include 'config.php';


?>
<!doctype html>
<html class="no-js" lang="en">

<!--   23:54:54 GMT -->

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo $sitename; ?> - <?php echo $site_title; ?></title>


    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta property="og:image" content="uploads/<?php echo $site_logo; ?>">

    <meta name="keywords" content=" <?php echo $sitename; ?> logistics, <?php echo $sitename; ?> transportation logistics, <?php echo $sitename; ?> logistics inc
        , <?php echo $sitename; ?> transportation logistics carrier setup, paramount transportation logistics services llc,uk based logistics companies, logistics companies uk, uk logistics companies
, largest uk logistics companies, <?php echo $sitename; ?> transportation logistics services ,<?php echo $sitename; ?> global logistics, <?php echo $sitename; ?> logistics fayetteville nc, revenant logistics inc paramount ca, <?php echo $sitename; ?> logistics courier, <?php echo $sitename; ?> logistics private limited, <?php echo $sitename; ?> logistics salem va, next generation logistics <?php echo $sitename; ?>,">


    <meta name="description" content="<?php echo $sitename; ?> Logistics is a premier logistics company offering global freight forwarding, transportation, and supply chain solutions. Our reliable and efficient services ensure on-time delivery, customized solutions, and exceptional customer satisfaction. Explore our expertise in international shipping, warehousing, and customs clearance.">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="uploads/<?php echo $site_logo; ?>">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/animate.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">
    <link rel="stylesheet" href="css/fontawesome-all.min.css">
    <link rel="stylesheet" href="css/aos.css">
    <link rel="stylesheet" href="css/nice-select.css">
    <link rel="stylesheet" href="css/flaticon.css">
    <link rel="stylesheet" href="css/meanmenu.css">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/default.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- main-area -->
    <main class="track">

        <!-- slider-area -->
        <section class="slider-area">
            <div class="slider-active">
                <div class="single-slider slider-bg d-flex align-items-center">
                    <div class="slider-overlay-bg"></div>
                    <div class="slider-bg-shape"></div>
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-xl-10 col-lg-11">
                                <div class="slider-content text-center">
                                    <h2 data-animation="fadeInUpS" data-delay=".3s">Track & Trace</h2>
                                    <p data-animation="fadeInUpS" data-delay=".6s">Enter tracking ID below.</p>
                                    <div class="slider-form" data-animation="fadeInUpS" data-delay=".9s">
                                        <form action="track" method="POST">
                                            <input type="text" name="tracking_number" placeholder="Tracking id">
                                            <button class="btn" name="tracking_number_submit">TRACK NOW</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>
        <!-- slider-area-end -->

        <?php
        if (isset($_POST['tracking_number'])) {
            $tracking_number = mysqli_real_escape_string($link, $_POST['tracking_number']);

            $sql = "SELECT * FROM tracking WHERE tracking_number='$tracking_number';";
            $result = mysqli_query($link, $sql);
            $row = mysqli_fetch_assoc($result);
            $numrows = mysqli_num_rows($result);
            if ($numrows > 0) {
        ?>

                <!-- about-area -->
                <section class="about-area about-bg">
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <div class="tracking-bar-section">
                                    <?php
                                    $sql1 = "SELECT * FROM track_update WHERE track_num='$tracking_number';";
                                    $result1 = mysqli_query($link, $sql1);
                                    $numrows1 = mysqli_num_rows($result1);
                                    $num1 = 1;
                                    $color_progress_bar = true;
                                    if ($numrows1 > 0) {
                                        while ($row1 = mysqli_fetch_assoc($result1)) {
                                    ?>
                                            <div class="box <?php if ($color_progress_bar == true) {
                                                                echo "active";
                                                            } ?>">
                                                <div class="progress-container">
                                                    <div class="middle-circle"><?php echo $num1; ?></div>
                                                </div>
                                                <div class="details">
                                                    <div class="status"><?php echo $row1['status'] ?> in <?php echo $row1['current_location'] ?></div>
                                                    <div class="note"><?php echo $row1['note'] ?></div>
                                                    <div class="date"><?php echo date('F dS, Y', strtotime($row1['date'])); ?></div>
                                                </div>
                                            </div>
                                            <!-- <div class="box active">
                                                <div class="progress-container">
                                                    <div class="middle-circle">2</div>
                                                </div>
                                                <div class="note">Picked by courier</div>
                                                <div class="date">September 14th, 2023</div>
                                            </div>
                                            <div class="box">
                                                <div class="progress-container last">
                                                    <div class="middle-circle">3</div>
                                                </div>
                                                <div class="note">On the way</div>
                                                <div class="date">September 14th, 2023</div>
                                            </div>
                                            <div class="box">
                                                <div class="progress-container last">
                                                    <div class="middle-circle">4</div>
                                                </div>
                                                <div class="note">Ready for pickup</div>
                                                <div class="date">September 14th, 2023</div>
                                            </div> -->

                                    <?php
                                            if ($row1['is_current_location'] == "yes") {
                                                $color_progress_bar = false;
                                            }
                                            $num1++;
                                        }
                                    }
                                    ?>



                                </div>


                            </div>
                        </div>
                    </div>
                </section>
                <!-- about-area-end -->



                <!-- bar code -container start -->
                <section class="services-area pt-10 pb-10">
                    <div class="container">
                        <div class="bar-code-container">
                            <div class="logo-container">
                                <img src="uploads/<?php echo $site_logo; ?>" alt="" class="logo">
                            </div>
                            <div style="display:flex;justify-content:center;margin:20px 0px;">
                                <img id="barcode" style="width:150px;height:auto;">
                            </div>
                        </div>
                    </div>
                </section>
                <!-- bar code container end -->


                <!-- sender and receiver -container start -->
                <section class="services-area pt-10 pb-10">
                    <div class="container">
                        <div class="sender-and-receiver-container">
                            <div class="row">
                                <div class="col-lg-6">
                                    <h5>Shipper Information</h5>
                                    <p>Name: <?php echo $row['sender_name']; ?></p>
                                    <p>Address: <?php echo $row['sender_address']; ?></p>
                                    <p>Phone Number: <?php echo $row['sender_contact']; ?></p>
                                    <p>Email: <?php echo $row['sender_email']; ?></p>
                                </div>
                                <div class="col-lg-6">
                                    <h5>Receiver Information</h5>
                                    <p>Name: <?php echo $row['receiver_name']; ?></p>
                                    <p>Address: <?php echo $row['receiver_address']; ?></p>
                                    <p>Phone Number: <?php echo $row['receiver_contact']; ?></p>
                                    <p>Email: <?php echo $row['receiver_email']; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- sender and receiver container end -->



                <!-- shipment information -container start -->
                <section class="services-area pt-10 pb-10">
                    <div class="container">
                        <div class="shipment-information-container">
                            <div class="section-title">SHIPMENT STATUS - <?php echo $row['status']; ?></div>
                            <div class="image-container">
                                <img src="uploads/<?php echo $row['image']; ?>" alt="" class="image">
                            </div>
                            <div class="row">
                                <div class="col-lg-3">
                                    <h6>Origin:</h6>
                                    <p><?php echo $row['dispatch_location']; ?></p>

                                    <h6>Carrier:</h6>
                                    <p><?php echo $row['carrier']; ?></p>

                                    <h6>Carrier Reference No:</h6>
                                    <p><?php echo $row['carrier_ref']; ?></p>

                                    
                                </div>
                                <div class="col-lg-3">
                                    <h6>Package:</h6>
                                    <p><?php echo $row['pdesc']; ?></p>

                                
                            <h6>Total Freight:</h6>
                                    <p><?php echo $row['quantity']; ?></p>
                                 

                                    <h6>Expected Delivery Date:</h6>
                                    <p><?php echo $row['delivery_date']; ?></p>
                                </div>
                                <div class="col-lg-3">
                                    <h6>Status:</h6>
                                    <p><?php echo $row['status']; ?></p>

                                    <h6>Weight:</h6>
                                    <p><?php echo $row['weight']; ?></p>

                                    

                                    <h6>Departure Date:</h6>
                                    <p><?php echo $row['dispatch_date']; ?></p>
                                </div>
                                <div class="col-lg-3">
                                    <h6>Destination:</h6>
                                    <p><?php echo $row['destination']; ?></p>

                                    <h6>Shipment Mode:</h6>
                                    <p><?php echo $row['ship_mode']; ?></p>

                                    <h6>Payment Mode:</h6>
                                    <p><?php echo $row['payment_mode']; ?></p>

                                    <h6>Delivery Time:</h6>
                                    <p><?php echo $row['delivery_time']; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- shipment information container end -->


                <!-- google maps -container start -->
                <?php
                if ($show_map == "Yes") {
                    $sql2 = "SELECT * FROM track_update WHERE track_num= '$tracking_number' ORDER BY id DESC LIMIT 1 ";
                    $result2 = mysqli_query($link, $sql2);
                    $row2 = mysqli_fetch_assoc($result2);
                ?>
                    <section class="services-area pt-10 pb-10">
                        <div class="container">
                            <div class="google-maps-container">
                                <iframe class="map" src="https://maps.google.com/maps?q=<?php echo $row2['current_location'] == "" ? $row['dispatch_location'] : $row2['current_location'] ?>&amp;t=k&amp;z=13&amp;ie=UTF8&amp;iwloc=&amp;output=embed" style="border:0; width: 100%; height: 527px;"></iframe>
                            </div>
                        </div>
                    </section>
                <?php
                }
                ?>
                <!-- google maps container end -->


                <!-- print receipt container -container start -->
                <?php
                if ($allow_print == "Yes") {
                ?>
                    <section class="services-area pt-10 pb-10">
                        <div class="container">
                            <div class="print-receipt-container">
                                <a href="receipt?tracking_number=<?php echo $tracking_number; ?>" class="print-receipt-btn">Print Receipt</a>
                            </div>
                        </div>
                    </section>
                <?php
                }
                ?>
                <!-- print receipt container container end -->

        <?php
            } else {
                echo "<script>alert('Invalid Tracking Number');window.location.href = './'; </script>";
            }
        }
        ?>

        <?php include 'footer.php'; ?>


        <!-- JS here -->



        <script src="js/vendor/jquery-1.12.4.min.js"></script>
        <script src="js/popper.min.js"></script>
        <script src="js/bootstrap.min.js"></script>
        <script src="js/isotope.pkgd.min.js"></script>
        <script src="js/slick.min.js"></script>
        <script src="js/jquery.meanmenu.min.js"></script>
        <script src="js/ajax-form.js"></script>
        <script src="js/wow.min.js"></script>
        <script src="js/aos.js"></script>
        <script src="js/paroller.js"></script>
        <script src="js/jquery.waypoints.min.js"></script>
        <script src="js/jquery.counterup.min.js"></script>
        <script src="js/jquery.nice-select.min.js"></script>
        <script src="js/jquery.scrollUp.min.js"></script>
        <script src="js/imagesloaded.pkgd.min.js"></script>
        <script src="js/jquery.magnific-popup.min.js"></script>
        <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCo_pcAdFNbTDCAvMwAD19oRTuEmb9M50c"></script>
        <script src="js/plugins.js"></script>

        <script src="js/main.js"></script>

        <script src="js/JsBarcode.all.min.js"></script>
        <script>
            JsBarcode("#barcode", "<?php echo $tracking_number; ?>");
        </script>
</body>

<!--   23:57:06 GMT -->

</html>