<?php
include 'db.php';
include 'config.php';
?>
<!doctype html>
<html class="no-js" lang="en">

<!-- service-air.html  23:59:27 GMT -->

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo $sitename; ?> - <?php echo $site_title; ?></title>


    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta property="og:image" content="uploads/<?php echo $site_logo; ?>">

    <meta name="keywords" content=" <?php echo $sitename; ?> logistics, <?php echo $sitename; ?> transportation logistics, <?php echo $sitename; ?> logistics inc
        , <?php echo $sitename; ?> transportation logistics carrier setup, paramount transportation logistics services llc,uk based logistics companies, logistics companies uk, uk logistics companies
, largest uk logistics companies, <?php echo $sitename; ?> transportation logistics services ,<?php echo $sitename; ?> global logistics, <?php echo $sitename; ?> logistics fayetteville nc, revenant logistics inc paramount ca, <?php echo $sitename; ?> logistics courier, <?php echo $sitename; ?> logistics private limited, <?php echo $sitename; ?> logistics salem va, next generation logistics <?php echo $sitename; ?>,">


    <meta name="description" content="<?php echo $sitename; ?> Logistics is a premier logistics company offering global freight forwarding, transportation, and supply chain solutions. Our reliable and efficient services ensure on-time delivery, customized solutions, and exceptional customer satisfaction. Explore our expertise in international shipping, warehousing, and customs clearance.">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="uploads/<?php echo $site_logo; ?>">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/animate.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">
    <link rel="stylesheet" href="css/fontawesome-all.min.css">
    <link rel="stylesheet" href="css/aos.css">
    <link rel="stylesheet" href="css/nice-select.css">
    <link rel="stylesheet" href="css/flaticon.css">
    <link rel="stylesheet" href="css/meanmenu.css">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/default.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- main-area -->
    <main>

        <!-- breadcrumb-area -->
        <div class="breadcrumb-area breadcrumb-bg s-breadcrumb-bg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb-content">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="dots"></li>
                                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Cargo Transportation</li>
                                    <li class="dots2"></li>
                                </ol>
                            </nav>
                            <h2>Cargor Transportation</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- breadcrumb-area-end -->

        <!-- services-details -->
        <div class="services-details-area pt-120 pb-115">
            <div class="container">
                <div class="services-details-wrap">
                    <div class="row">
                        <div class="col-lg-4 order-2 order-lg-0">
                            <aside class="services-sidebar">
                                <div class="services-widget mb-40">
                                    <div class="service-widget-title">
                                        <h3>Service Category</h3>
                                    </div>
                                    <div class="service-cat-list">
                                        <ul>
                                            <li class="active"><a href="cargo-transportation">Cargo Transportation</a></li>
                                            <li><a href="air-freight">Air Freight</a></li>
                                            <li><a href="ocean-freight">Ocean Freight</a></li>
                                            <li><a href="packaging-and-storage">Packaging & Storage</a></li>
                                        </ul>
                                    </div>
                                </div>

                                <div class="services-widget mb-40">
                                    <div class="service-sidebar-support">
                                        <h3>Need Support?</h3>
                                        <p>We're always happy to help you out</p>
                                        <a href="contact" class="btn">contact Us</a>
                                    </div>
                                </div>

                            </aside>
                        </div>
                        <div class="col-lg-8">
                            <div class="services-details-content">
                                <img src="images/resource/fleet-8.jpg" style="width:100%;height:auto;margin-bottom:20px;" alt="">
                                <p><?php echo $sitename; ?> offers comprehensive road freight solutions to meet the diverse transportation needs of businesses and individuals. As a trusted logistics partner, we understand the significance of road transportation in connecting regions, facilitating trade, and ensuring timely deliveries. With our extensive network, experienced team, and commitment to excellence, we provide reliable and cost-effective road freight services tailored to our clients' specific requirements.</p>
                                <p>Discover the Power of Cargo Transportation: Experience a seamless shipping experience like no other with our Ocean Freight solutions. Whether you are transporting large shipments, oversized cargo, or require cost-effective transportation options, our Ocean Freight services are designed to meet your unique needs.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- services-details-end -->


    </main>
    <!-- main-area-end -->

    <?php include 'footer.php'; ?>




    <!-- JS here -->

    <script src="js/vendor/jquery-1.12.4.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/isotope.pkgd.min.js"></script>
    <script src="js/slick.min.js"></script>
    <script src="js/jquery.meanmenu.min.js"></script>
    <script src="js/ajax-form.js"></script>
    <script src="js/wow.min.js"></script>
    <script src="js/aos.js"></script>
    <script src="js/paroller.js"></script>
    <script src="js/jquery.waypoints.min.js"></script>
    <script src="js/jquery.counterup.min.js"></script>
    <script src="js/jquery.nice-select.min.js"></script>
    <script src="js/jquery.scrollUp.min.js"></script>
    <script src="js/imagesloaded.pkgd.min.js"></script>
    <script src="js/jquery.magnific-popup.min.js"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCo_pcAdFNbTDCAvMwAD19oRTuEmb9M50c"></script>
    <script src="js/plugins.js"></script>
    <script src="js/main.js"></script>
</body>

<!-- service-air.html  23:59:27 GMT -->

</html>